package io.bidmachine.schema.analytics

import enumeratum.values.{StringEnum, StringEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class BidStatus(val value: String) extends StringEnumEntry

object BidStatus extends StringEnum[BidStatus] with JsoniterEnumInstances {
  case object Loss extends BidStatus("loss")
  case object Win  extends BidStatus("win")

  def values = findValues
}
