package io.bidmachine.schema.rtb

import java.time.Instant

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class AdCachingInfo(
  bidTimestamp: Option[Instant],
  adRequestsReceived: Long,
  syntheticRequestsMade: Long,
  ttl: Long // milliseconds
)

object AdCachingInfo {
  implicit val adCachingInfoCodec: JsonValueCodec[AdCachingInfo] = JsonCodecMaker.make[AdCachingInfo](CodecMakerConfig)
}
