package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

// Single event representing the entire auction
// For the next version of this event we might consider https://docs.metamarkets.com/docs/integration-guide-for-exchanges
case class AuctionEvent(
  timestamp: Instant,
  meta: EventMeta,
  seller: Seller,
  request: Request,
  dspRequests: List[DSPRequest],
  rejectedAdRequestReason: Option[String] // in case request was dropped on seller level
)

case class DSPRequest(
  buyer: Buyer,
  bid: Bid,
  // only overridden labels on DSP level i.e. bidder, bid, win, response level
  meta: EventMeta,
  // in case request was dropped by Auction e.g. due to SRO block or was rejected by DSP e.g. timeout
  rejectedDSPRequestReason: Option[
    String
  ]
  //@todo, later add model/fields which could be overridden e.g. floors, fee
)

object AuctionEvent {
  implicit val auctionEventCodec: JsonValueCodec[AuctionEvent] = JsonCodecMaker.make[AuctionEvent](CodecMakerConfig)
}

object DSPRequest {
  implicit val dspRequestCodec: JsonValueCodec[DSPRequest] = JsonCodecMaker.make[DSPRequest](CodecMakerConfig)
}
