package io.bidmachine.schema.rtb

import enumeratum.values.{StringEnum, StringEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ConsentStringVersion(val value: String) extends StringEnumEntry

object ConsentStringVersion extends StringEnum[ConsentStringVersion] with JsoniterEnumInstances {

  case object Empty extends ConsentStringVersion("empty")

  case object TCF2_2 extends ConsentStringVersion("TCF 2.2")

  case object TCF2_0 extends ConsentStringVersion("TCF 2.0")

  case object TCF1_1 extends ConsentStringVersion("TCF 1.1")

  case object BooleanConsent extends ConsentStringVersion("boolean consent")

  case object NoConsent extends ConsentStringVersion("no consent")

  case object Invalid extends ConsentStringVersion("invalid")

  val values = findValues
}
