package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class PlacementPosition(val value: Int) extends IntEnumEntry

object PlacementPosition extends IntEnum[PlacementPosition] with JsoniterEnumInstances {

  case object AboveFold  extends PlacementPosition(1)
  case object Locked     extends PlacementPosition(2)
  case object BelowFold  extends PlacementPosition(3)
  case object Header     extends PlacementPosition(4)
  case object Footer     extends PlacementPosition(5)
  case object SideBar    extends PlacementPosition(6)
  case object FullScreen extends PlacementPosition(7)

  val values = findValues
}
