package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

case class IvtDetectionEvent(
  timestamp: Instant,
  meta: EventMeta,
  seller: Seller,
  request: Request,
  ivtDetectionResult: IvtDetectionResult
)

object IvtDetectionEvent {
  implicit val ivtDetectionCodec: JsonValueCodec[IvtDetectionEvent] =
    JsonCodecMaker.make[IvtDetectionEvent](CodecMakerConfig)
}
