package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

// A model representing Bidder / DSP / Agency
case class Buyer(
  id: Long,
  bidderId: Long,
  pretargetingId: Long,
  directRelation: Option[Boolean],  // whether request came from direct relation agency (p2p)
  auctionCategory: Option[String],
  dspConnectionType: Option[String] // agency level parameter, same for all bidders in agency
)

object Buyer {
  implicit val buyerCodec: JsonValueCodec[Buyer] = JsonCodecMaker.make[Buyer](CodecMakerConfig)
}
