package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class MediaRating(val value: Int) extends IntEnumEntry

object MediaRating extends IntEnum[MediaRating] with JsoniterEnumInstances {

  case object AllAudiences    extends MediaRating(1)
  case object OverAge12       extends MediaRating(2)
  case object MatureAudiences extends MediaRating(3)

  val values = findValues
}
