package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{AdCachedBid, AdCachedRequest}

import java.time.Instant

case class AdCachedBidEvent(
  timestamp: Instant,
  syntheticAdRequestNumber: Long,
  meta: EventMeta,
  buyerId: Option[Long],
  bidderId: Option[Long],
  sellerId: Long,
  sourceId: Long,
  request: AdCachedRequest,
  bid: Option[AdCachedBid]
)

object AdCachedBidEvent {
  implicit val adCachedBidEventCodec: JsonValueCodec[AdCachedBidEvent] =
    JsonCodecMaker.make[AdCachedBidEvent](CodecMakerConfig)
}
