package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class DeviceType(val value: Int) extends IntEnumEntry

object DeviceType extends IntEnum[DeviceType] with JsoniterEnumInstances {

  case object Mobile    extends DeviceType(1)
  case object PC        extends DeviceType(2)
  case object TV        extends DeviceType(3)
  case object Phone     extends DeviceType(4)
  case object Tablet    extends DeviceType(5)
  case object Connected extends DeviceType(6)
  case object SetTopBox extends DeviceType(7)

  val values = findValues
}
