/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.config.providers;

import io.bidmachine.config.exceptions.ConfigProviderException;
import io.bidmachine.config.providers.ArchiveConfigProvider;
import io.bidmachine.config.providers.ConfigProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenZConfigProvider
extends ArchiveConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(SevenZConfigProvider.class);
    private SevenZFile arcFileHandle;
    private Map<String, SevenZArchiveEntry> arcEntryMap;

    public SevenZConfigProvider(String aArcPath) {
        super(aArcPath);
    }

    private void putEntryIntoMap(SevenZArchiveEntry aEntry) {
        boolean isDir = aEntry.isDirectory();
        String name = aEntry.getName();
        if (isDir) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.putDirToMap(name);
        } else {
            int i = name.lastIndexOf(47);
            String dirName = name.substring(0, i);
            this.putDirToMap(dirName);
            String fileName = name.substring(i + 1);
            String fileFullPath = dirName + "/" + fileName;
            this.putIntoMap(this.fileFullPathMap, dirName, fileFullPath);
            this.arcEntryMap.put(fileFullPath, aEntry);
        }
    }

    @Override
    protected void scanArchive(String aArchiveFilename) {
        this.arcEntryMap = new TreeMap<String, SevenZArchiveEntry>();
        log.info(String.format("Configuration will be loaded from %s", aArchiveFilename));
        if (!aArchiveFilename.endsWith(".7z")) {
            throw new IllegalArgumentException(String.format("The file name must end with '.7z', but unfortunately it is %s", aArchiveFilename));
        }
        try {
            this.arcFileHandle = ((SevenZFile.Builder)SevenZFile.builder().setFile(aArchiveFilename)).get();
        }
        catch (IOException ex) {
            throw new ConfigProviderException(String.format("Error opening the 7z file %s: %s", aArchiveFilename, ex.getMessage()), ex);
        }
        Iterable entries = this.arcFileHandle.getEntries();
        for (SevenZArchiveEntry e : entries) {
            this.putEntryIntoMap(e);
        }
    }

    @Override
    public InputStream getInputStream(String aResourceName) {
        String resourceName = aResourceName;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        try {
            SevenZArchiveEntry entry = this.arcEntryMap.get(resourceName);
            if (entry == null) {
                throw new ConfigProviderException(String.format("There are no entry named %s in the 7z file %s", aResourceName, this.arcFile));
            }
            return new BufferedInputStream(this.arcFileHandle.getInputStream(entry), 131072);
        }
        catch (IOException ex) {
            throw new ConfigProviderException(String.format("Error reading the 7z file %s: %s", this.arcFile, ex.getMessage()), ex);
        }
    }

    public String toString() {
        return String.format("SevenZConfigProvider{arcFile='%s'}", this.arcFile);
    }
}

