/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EcpmMutator
extends BaseMutator
implements Mutator {
    public static final String[] ECPM_AD_TYPES = new String[]{"inter", "rewarded"};
    public static final String[] ECPM_METRICS = new String[]{"last_real_ecpm", "avg_real_ecpm", "avg_real_ecpm_w3", "avg_real_ecpm_w5", "real_ecpm_lin_pred_l2", "real_ecpm_newt_pred_l3"};

    @Override
    public Set<String> infoCalcFeatures() {
        HashSet<String> features = new HashSet<String>(Arrays.asList(ECPM_METRICS));
        for (String adtype : ECPM_AD_TYPES) {
            for (String m : ECPM_METRICS) {
                features.add(m + "_" + adtype);
            }
        }
        return features;
    }

    @Override
    public Set<String> infoInputFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (String adt : ECPM_AD_TYPES) {
            features.add("ecpm_" + adt);
        }
        return features;
    }

    public EcpmMutator(String aID) {
        super(aID);
    }

    private void fillNaN(FeatureRecord aFeatureRecord, String aAdType) {
        for (String metric : ECPM_METRICS) {
            aFeatureRecord.put(metric + "_" + aAdType, Float.valueOf(Float.NaN));
        }
    }

    private List<String> readyMetricsKeysGet(FeatureRecord aFeatureRecord, String aAdType) {
        ArrayList<String> result = null;
        for (String metric : ECPM_METRICS) {
            if (!aFeatureRecord.containsKey(metric + "_" + aAdType)) continue;
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(metric);
        }
        return result;
    }

    private Map<String, Object> calcRealEcpmFeaturesRowByRow(float[] aPrices, String aAdType) {
        float last_elem_col = aPrices[aPrices.length - 1];
        float second_last_elem_col = aPrices.length >= 2 ? aPrices[aPrices.length - 2] : Float.NaN;
        float third_last_elem_col = aPrices.length >= 3 ? aPrices[aPrices.length - 3] : Float.NaN;
        float lin_pred_col = Math.max(2.0f * last_elem_col - second_last_elem_col, 0.0f);
        float lin_pred_real_ecpm_col = aPrices.length > 1 ? lin_pred_col : last_elem_col;
        float d1_col = second_last_elem_col - third_last_elem_col;
        float d2_col = last_elem_col - second_last_elem_col;
        float d2_2_col = d2_col - d1_col;
        float newt_pred_col = Math.max(last_elem_col + d2_col + d2_2_col, 0.0f);
        float newt_pred_real_ecpm_col = aPrices.length > 2 ? newt_pred_col : lin_pred_real_ecpm_col;
        return Map.ofEntries(Map.entry("last_real_ecpm_" + aAdType, Float.valueOf(last_elem_col)), Map.entry("avg_real_ecpm_" + aAdType, Float.valueOf(this.avg(aPrices))), Map.entry("avg_real_ecpm_w3_" + aAdType, Float.valueOf(this.dynamicAvg(aPrices, 3))), Map.entry("avg_real_ecpm_w5_" + aAdType, Float.valueOf(this.dynamicAvg(aPrices, 5))), Map.entry("real_ecpm_lin_pred_l2_" + aAdType, Float.valueOf(lin_pred_real_ecpm_col)), Map.entry("real_ecpm_newt_pred_l3_" + aAdType, Float.valueOf(newt_pred_real_ecpm_col)));
    }

    private void processEcpm(FeatureRecord aFeatureRecord, String aAdType, Map<String, Object> aMap) {
        float[] prices;
        float[] firstPrices = (float[])aMap.get("firstPrices");
        float[] lastPrices = (float[])aMap.get("lastPrices");
        Object countObject = aMap.get("count");
        int count = 0;
        if (countObject != null) {
            count = (Integer)countObject;
        }
        if (firstPrices == null) {
            firstPrices = new float[]{};
        }
        if (lastPrices == null) {
            lastPrices = new float[]{};
        }
        if (count <= 0 || firstPrices.length + lastPrices.length == 0) {
            this.fillNaN(aFeatureRecord, aAdType);
            return;
        }
        if (count <= 10 && firstPrices.length + lastPrices.length != count) {
            aFeatureRecord.stop(String.format("Troubles with adt=%s  count=%d:  first.length=%d, second.length=%d", aAdType, count, firstPrices.length, lastPrices.length));
            return;
        }
        if (count <= 5) {
            prices = firstPrices;
        } else if (count >= 10) {
            prices = lastPrices;
        } else {
            prices = new float[5];
            System.arraycopy(firstPrices, lastPrices.length, prices, 0, 5 - lastPrices.length);
            System.arraycopy(lastPrices, 0, prices, 5 - lastPrices.length, lastPrices.length);
        }
        Map<String, Object> ecpmFeatures = this.calcRealEcpmFeaturesRowByRow(prices, aAdType);
        aFeatureRecord.put(ecpmFeatures);
    }

    private float dynamicAvg(float[] a, int aWindow) {
        int start = Math.max(a.length - aWindow, 0);
        float s = 0.0f;
        for (int i = start; i < a.length; ++i) {
            s += a[i];
        }
        return s / (float)(a.length - start);
    }

    private float avg(float[] a) {
        float s = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            s += a[i];
        }
        return s / (float)a.length;
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) {
        for (String adt : ECPM_AD_TYPES) {
            int cntMetrics;
            List<String> readyMetrics = this.readyMetricsKeysGet(aFeatureRecord, adt);
            int n = cntMetrics = readyMetrics == null ? 0 : readyMetrics.size();
            if (cntMetrics > 0 && cntMetrics < ECPM_METRICS.length) {
                String foundMetrics = CollectionUtils.toStr(readyMetrics);
                aFeatureRecord.stop(String.format("adt=%s, part of ecpm metrics (%s) are found which should not be like that: either all or none should be filled in", adt, foundMetrics));
                return aFeatureRecord;
            }
            if (!aFeatureRecord.containsKey("ecpm_" + adt)) {
                if (cntMetrics != 0) continue;
                aFeatureRecord.stop(String.format("ecpm_%s is not present, but the individual metrics are not found too", adt));
                return aFeatureRecord;
            }
            if (cntMetrics > 0) {
                aFeatureRecord.stop(String.format("ecpm_%s key is present, but %d metrics are present too, and this shoul'd be like that", adt, cntMetrics));
                return aFeatureRecord;
            }
            Object value = aFeatureRecord.get("ecpm_" + adt);
            if (value == null) {
                this.fillNaN(aFeatureRecord, adt);
                continue;
            }
            this.processEcpm(aFeatureRecord, adt, (Map)value);
        }
        return aFeatureRecord;
    }
}

