/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import io.bidmachine.utils.OS;
import io.bidmachine.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathUtils {
    private static Set<Character> validChars;
    private static final String GENERIC_SLASH = "/";

    private PathUtils() {
    }

    public static String getSafeFilename(String aFilename) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < aFilename.length(); ++i) {
            char c = aFilename.charAt(i);
            if (validChars.contains(Character.valueOf(c))) {
                result.append(c);
                continue;
            }
            result.append("_");
        }
        return result.toString();
    }

    private static String getOnlyDir(String aFullFilename, String aSlash) {
        int i = aFullFilename.lastIndexOf(aSlash);
        if (i >= 0) {
            return aFullFilename.substring(0, i + 1);
        }
        return "";
    }

    public static String getOnlyDirOS(String aFullFilename) {
        return PathUtils.getOnlyDir(aFullFilename, OS.getDirSlash());
    }

    public static String getOnlyDirGeneric(String aFullFilename) {
        return PathUtils.getOnlyDir(aFullFilename, GENERIC_SLASH);
    }

    private static String getSubdirAtFileDir(String aFullFilename, String aSubdir, String aSlash) {
        String dir = PathUtils.getOnlyDir(aFullFilename, aSlash);
        return dir + aSubdir;
    }

    public static String getSubdirAtFileDirOS(String aFullFilename, String aSubdir) {
        return PathUtils.getSubdirAtFileDir(aFullFilename, aSubdir, OS.getDirSlash());
    }

    public static String getSubdirAtFileDirGeneric(String aFullFilename, String aSubdir) {
        return PathUtils.getSubdirAtFileDir(aFullFilename, aSubdir, GENERIC_SLASH);
    }

    private static String joinPath(String aPath1, String aPath2, String aSlash) {
        String end = aSlash;
        if (aPath1.isEmpty() || aPath1.endsWith(aSlash)) {
            end = "";
        }
        return aPath1 + end + aPath2;
    }

    public static String joinPathOS(String aPath1, String aPath2) {
        return PathUtils.joinPath(aPath1, aPath2, OS.getDirSlash());
    }

    public static String joinPathOS(String aPath1, String aPath2, String aPath3) {
        String slash = OS.getDirSlash();
        return PathUtils.joinPath(PathUtils.joinPath(aPath1, aPath2, slash), aPath3, slash);
    }

    public static String joinPathGeneric(String aPath1, String aPath2) {
        return PathUtils.joinPath(aPath1, aPath2, GENERIC_SLASH);
    }

    public static String joinPathGeneric(String aPath1, String aPath2, String aPath3) {
        return PathUtils.joinPath(PathUtils.joinPath(aPath1, aPath2, GENERIC_SLASH), aPath3, GENERIC_SLASH);
    }

    private static String getOnlyName(String aFullFilePath, String aSlash) {
        if (!aFullFilePath.contains(aSlash)) {
            return aFullFilePath;
        }
        return aFullFilePath.substring(aFullFilePath.lastIndexOf(aSlash) + 1);
    }

    public static String getOnlyNameOS(String aFullFilePath) {
        return PathUtils.getOnlyName(aFullFilePath, OS.getDirSlash());
    }

    public static String getOnlyNameGeneric(String aFullFilePath) {
        return PathUtils.getOnlyName(aFullFilePath, GENERIC_SLASH);
    }

    private static List<String> wildcardFilter(Collection<String> aStringCollection, String aWildcard, String aSlash) {
        ArrayList<String> result = new ArrayList<String>();
        for (String file : aStringCollection) {
            String fileNameOnly = file.substring(file.lastIndexOf(aSlash) + 1);
            if (!StringUtils.wildcardMatch(fileNameOnly, aWildcard)) continue;
            result.add(file);
        }
        return result;
    }

    public static List<String> wildcardFilterOS(Collection<String> aStringCollection, String aWildcard) {
        return PathUtils.wildcardFilter(aStringCollection, aWildcard, OS.getDirSlash());
    }

    public static List<String> wildcardFilterGeneric(Collection<String> aStringCollection, String aWildcard) {
        return PathUtils.wildcardFilter(aStringCollection, aWildcard, GENERIC_SLASH);
    }

    static {
        char c;
        validChars = null;
        validChars = new HashSet<Character>();
        char[] cArray = "-_.() ".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c2 = Character.valueOf(cArray[i]);
            validChars.add(c2);
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + 1)) {
            validChars.add(Character.valueOf(c));
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            validChars.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            validChars.add(Character.valueOf(c));
        }
    }
}

