/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.data;

import io.bidmachine.config.data.DataTypeEnum;
import io.bidmachine.config.data.FieldConfig;
import io.bidmachine.config.data.SchemaConfig;
import io.bidmachine.data.DataFrame;
import io.bidmachine.data.DataFrameException;
import io.bidmachine.data.DataFrameProblem;
import io.bidmachine.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InMemoryDataFrame
implements DataFrame {
    public static final String NO_INDEX = "The dataIndex is not built for this dataframe";
    private final List<Object[]> data;
    private final SchemaConfig schema;
    private final String[] fields;
    private final String[] keyFields;
    private final Map<String, Integer> fieldPos;
    private HashMap<List<Object>, Object[]> dataIndex;
    private final int[] keyFieldsPos;
    private final Class[] keyFieldsDesiredClass;
    private static final EnumMap<DataTypeEnum, Class> mapTypeToDesiredClass = new EnumMap(DataTypeEnum.class);

    private void buildIndex() {
        this.dataIndex = new HashMap();
        for (Object[] record : this.data) {
            ArrayList<Object> key = new ArrayList<Object>(this.keyFields.length);
            for (int i = 0; i < this.keyFields.length; ++i) {
                key.add(record[this.keyFieldsPos[i]]);
            }
            if (this.dataIndex.containsKey(key)) {
                throw new DataFrameException(String.format("Duplicated record: the item %s already exists", CollectionUtils.toStr(key)), DataFrameProblem.BUILD_INDEX_DUPLICATE);
            }
            this.dataIndex.put(key, record);
        }
    }

    public InMemoryDataFrame(SchemaConfig aSchema, List<Object[]> aData) {
        this.schema = aSchema;
        this.data = aData;
        List<FieldConfig> fcList = aSchema.getFieldConfigs();
        this.fields = new String[fcList.size()];
        int i = 0;
        for (FieldConfig fc : fcList) {
            this.fields[i++] = fc.getName();
        }
        this.fieldPos = new LinkedHashMap<String, Integer>();
        for (i = 0; i < this.fields.length; ++i) {
            this.fieldPos.put(this.fields[i], i);
        }
        this.keyFields = aSchema.getKey();
        this.keyFieldsPos = new int[this.keyFields.length];
        this.keyFieldsDesiredClass = new Class[this.keyFields.length];
        if (this.keyFields.length > 0) {
            for (i = 0; i < this.keyFields.length; ++i) {
                Integer v = this.fieldPos.get(this.keyFields[i]);
                if (v == null) {
                    throw new IllegalArgumentException("Key field " + this.keyFields[i] + " is not present in the list of fields of the schema");
                }
                this.keyFieldsPos[i] = v;
                this.keyFieldsDesiredClass[i] = mapTypeToDesiredClass.get((Object)this.schema.getFieldConfig(this.keyFields[i]).getType());
            }
            this.buildIndex();
        }
    }

    @Override
    public Object[] getRowByKey(Object[] aKeyFieldValues) {
        if (this.dataIndex == null) {
            throw new IllegalStateException(NO_INDEX);
        }
        return this.dataIndex.get(Arrays.asList(aKeyFieldValues));
    }

    @Override
    public Object[] getRowByKeyChecked(Object[] aKeyFieldValues) {
        if (this.dataIndex == null) {
            throw new IllegalStateException(NO_INDEX);
        }
        if (this.keyFields.length != aKeyFieldValues.length) {
            throw new DataFrameException(String.format("IndexedDataFrame has key %s of length %d but an attempt is made to search by array of size %d.", CollectionUtils.toStr(this.keyFields), this.keyFields.length, aKeyFieldValues.length), DataFrameProblem.SEARCH_WRONG_LENGTH);
        }
        for (int i = 0; i < aKeyFieldValues.length; ++i) {
            if (aKeyFieldValues[i] == null || this.keyFieldsDesiredClass[i].equals(aKeyFieldValues[i].getClass())) continue;
            throw new DataFrameException(String.format("Type mismatch. Column position: %d, column name: %s, column desired type: %s, searched value: %s, searched type: %s", i, this.keyFields[i], this.keyFieldsDesiredClass[i], aKeyFieldValues[i], aKeyFieldValues[i].getClass()), DataFrameProblem.SEARCH_TYPE_MISMATCH);
        }
        Object[] result = this.dataIndex.get(Arrays.asList(aKeyFieldValues));
        if (result == null) {
            throw new DataFrameException(String.format("Cannot find the row by key %s", CollectionUtils.toStr(aKeyFieldValues)), DataFrameProblem.SEARCH_NOT_FOUND);
        }
        return result;
    }

    @Override
    public Map<String, Object> getRowByKeyAsMap(Object[] aKeyFieldValues) {
        Object[] result = this.getRowByKey(aKeyFieldValues);
        if (result == null) {
            return null;
        }
        return CollectionUtils.zip(this.fields, result);
    }

    @Override
    public Map<String, Object> getRowByKeyAsMapChecked(Object[] aKeyFieldValues) {
        return CollectionUtils.zip(this.fields, this.getRowByKeyChecked(aKeyFieldValues));
    }

    @Override
    public SchemaConfig getSchema() {
        return this.schema;
    }

    @Override
    public Object[] getFieldValues(String aFieldName) {
        int fieldPosition = this.fieldPos.get(aFieldName);
        int size = this.data.size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.data.get(i)[fieldPosition];
        }
        return result;
    }

    @Override
    public List<Object[]> getData() {
        return this.data;
    }

    @Override
    public Object[] getRow(int aIndex) {
        return this.data.get(aIndex);
    }

    @Override
    public Map<String, Object> getRowAsMap(int aIndex) {
        return CollectionUtils.zip(this.fields, this.data.get(aIndex));
    }

    static {
        mapTypeToDesiredClass.put(DataTypeEnum.FLOAT, Float.class);
        mapTypeToDesiredClass.put(DataTypeEnum.DOUBLE, Double.class);
        mapTypeToDesiredClass.put(DataTypeEnum.INT, Integer.class);
        mapTypeToDesiredClass.put(DataTypeEnum.LONG, Long.class);
        mapTypeToDesiredClass.put(DataTypeEnum.STRING, String.class);
        mapTypeToDesiredClass.put(DataTypeEnum.BOOL, Boolean.class);
    }
}

