/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.data;

import io.bidmachine.config.data.SchemaConfig;
import io.bidmachine.config.data.SchemaConfigReader;
import io.bidmachine.config.exceptions.ConfigException;
import io.bidmachine.config.providers.ConfigProvider;
import io.bidmachine.csv.SchemaCsvBridge;
import io.bidmachine.data.DataFrame;
import io.bidmachine.data.InMemoryDataFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.BOMInputStream;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class InMemoryDataFrameReader {
    private InMemoryDataFrameReader() {
    }

    public static DataFrame readCsv(ConfigProvider aConfigProvider, String aResourceName) throws IOException, ConfigException {
        if (!aResourceName.endsWith(".csv")) {
            throw new IllegalArgumentException("Resource name should end with .csv");
        }
        SchemaConfig schemaConfig = SchemaConfigReader.read(aConfigProvider, aResourceName.replace(".csv", ".schema"));
        CellProcessor[] processors = SchemaCsvBridge.createProcessors(schemaConfig);
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        try (InputStream inputStream = aConfigProvider.getInputStream(aResourceName);
             BOMInputStream bomInputStream = new BOMInputStream(inputStream);
             CsvListReader listReader = new CsvListReader((Reader)new InputStreamReader((InputStream)bomInputStream, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);){
            List record;
            listReader.getHeader(true);
            while ((record = listReader.read(processors)) != null) {
                records.add(record.toArray());
            }
        }
        return new InMemoryDataFrame(schemaConfig, records);
    }
}

