/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private FileUtils() {
    }

    private static String[] getFileNames(File[] aFiles) {
        String[] result = new String[aFiles.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = aFiles[i].getName();
        }
        return result;
    }

    private static String[] getAbsolutePaths(File[] aFiles) {
        String[] result = new String[aFiles.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = aFiles[i].getAbsolutePath();
        }
        return result;
    }

    public static File[] listFilesWildcard(String aDir, String aWildcardPattern) {
        File dir = new File(aDir);
        File[] result = dir.listFiles((aFileDir, aFileName) -> FilenameUtils.wildcardMatch((String)aFileName, (String)aWildcardPattern));
        if (result == null) {
            return new File[0];
        }
        return result;
    }

    public static String[] listFilesAbsolutePathWildcard(String aDir, String aWildcardPattern) {
        return FileUtils.getAbsolutePaths(FileUtils.listFilesWildcard(aDir, aWildcardPattern));
    }

    public static File[] listFilesRegex(String aDir, String aRegexPattern) {
        File dir = new File(aDir);
        Pattern p = Pattern.compile(aRegexPattern);
        File[] result = dir.listFiles((aFileDir, aFileName) -> p.matcher(aFileName).matches());
        if (result == null) {
            return new File[0];
        }
        return result;
    }

    public static String[] listFilesAbsolutePathRegex(String aDir, String aRegexPattern) {
        return FileUtils.getAbsolutePaths(FileUtils.listFilesRegex(aDir, aRegexPattern));
    }

    public static String[] listFilesNamesRegex(String aDir, String aRegexPattern) {
        return FileUtils.getFileNames(FileUtils.listFilesRegex(aDir, aRegexPattern));
    }

    public static boolean fileExists(String aFileFullName) {
        File file = new File(aFileFullName);
        return file.exists() && file.isFile();
    }

    public static boolean dirExists(String aDir) {
        File file = new File(aDir);
        return file.exists() && file.isDirectory();
    }

    public static void deleteFile(String aFullFilePath) throws IOException {
        Files.delete(Paths.get(aFullFilePath, new String[0]));
    }

    public static void deleteFile(File aFile) throws IOException {
        Files.delete(Paths.get(aFile.getAbsolutePath(), new String[0]));
    }
}

