/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public class StringUtils {
    private StringUtils() {
    }

    public static String removeCRLF(String aString) {
        return aString.replaceAll("\\r|\\n", "");
    }

    public static boolean wildcardMatch(String aStr, String aPattern) {
        int i = 0;
        int j = 0;
        int starIndex = -1;
        int iIndex = -1;
        while (i < aStr.length()) {
            if (j < aPattern.length() && (aPattern.charAt(j) == '?' || aPattern.charAt(j) == aStr.charAt(i))) {
                ++i;
                ++j;
                continue;
            }
            if (j < aPattern.length() && aPattern.charAt(j) == '*') {
                starIndex = j++;
                iIndex = i;
                continue;
            }
            if (starIndex != -1) {
                j = starIndex + 1;
                i = iIndex + 1;
                ++iIndex;
                continue;
            }
            return false;
        }
        while (j < aPattern.length() && aPattern.charAt(j) == '*') {
            ++j;
        }
        return j == aPattern.length();
    }

    public static boolean regexMatch(String aStr, String aRegexPattern) {
        Pattern p = Pattern.compile(aRegexPattern);
        return p.matcher(aStr).matches();
    }

    public static List<String> asList(String ... aStringArray) {
        ArrayList<String> result = new ArrayList<String>(aStringArray.length);
        Collections.addAll(result, aStringArray);
        return result;
    }

    public static String newGuid() {
        return UUID.randomUUID().toString();
    }

    public static String newGuidHash() {
        return Integer.toHexString(StringUtils.newGuid().hashCode());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrEmptyOrSpace(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String coalesce(String ... aValues) {
        for (String val : aValues) {
            if (StringUtils.isNullOrEmptyOrSpace(val)) continue;
            return val;
        }
        return null;
    }

    public static String join(Enumeration<String> aStrings, String aSeparator) {
        StringBuilder result = new StringBuilder();
        boolean firstLine = true;
        while (aStrings.hasMoreElements()) {
            String s = aStrings.nextElement();
            if (!firstLine) {
                result.append(aSeparator);
            }
            firstLine = false;
            result.append(s);
        }
        return result.toString();
    }

    public static String lowercase(String str) {
        if (StringUtils.isNullOrEmptyOrSpace(str)) {
            return str;
        }
        return str.toLowerCase();
    }

    public static boolean isUserIdEmpty(String aId) {
        if (aId == null) {
            return true;
        }
        for (int i = 0; i < aId.length(); ++i) {
            char c = aId.charAt(i);
            if (c == '0' || c == '-' || c == ' ') continue;
            return false;
        }
        return true;
    }
}

