/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.csv;

import io.bidmachine.csv.DoubleHexCellProcessor;
import io.bidmachine.utils.HexParser;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class ParseDoubleHex
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseDoubleHex() {
    }

    public ParseDoubleHex(DoubleHexCellProcessor next) {
        super((CellProcessor)next);
    }

    public Object execute(Object value, CsvContext context) {
        Double result;
        this.validateInputNotNull(value, context);
        if (value instanceof Double) {
            result = (Double)value;
        } else if (value instanceof String) {
            try {
                result = HexParser.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a HexDouble", value), context, (CellProcessor)this, (Throwable)e);
            }
        } else {
            String actualClassName = value.getClass().getName();
            throw new SuperCsvCellProcessorException(String.format("the input value should be of type Double or String but is of type %s", actualClassName), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }
}

