/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.data;

import io.bidmachine.utils.CheckedHashMap;
import io.bidmachine.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class FeatureRecord {
    private final CheckedHashMap<String, Object> features;
    private List<String> stopInfo;

    public FeatureRecord(Map<String, Object> aFeatures) {
        this.features = aFeatures instanceof CheckedHashMap ? (CheckedHashMap<Object, Object>)aFeatures : new CheckedHashMap<String, Object>(aFeatures);
    }

    public boolean isStopped() {
        return this.stopInfo != null;
    }

    public final void stop(String aMessage) {
        if (this.stopInfo == null) {
            this.stopInfo = new ArrayList<String>();
        }
        this.stopInfo.add(aMessage);
    }

    public final String getStopInfo() {
        return CollectionUtils.toStr(this.stopInfo, "; ");
    }

    public Object get(String aFeatureName) {
        return this.features.get(aFeatureName);
    }

    public boolean containsKey(String aFeatureName) {
        return this.features.containsKey(aFeatureName);
    }

    public Set<String> getKeys() {
        return this.features.keySet();
    }

    public Object getOrDefault(String aFeatureName, Object aDefaultValue) {
        return this.features.getOrDefault(aFeatureName, aDefaultValue);
    }

    public Object put(String aFeatureName, Object aValue) {
        return this.features.put(aFeatureName, aValue);
    }

    public void put(Map<String, Object> aFeatures) {
        for (Map.Entry<String, Object> entry : aFeatures.entrySet()) {
            this.features.put(entry.getKey(), entry.getValue());
        }
    }

    public void putIfNotExists(String aFeatureName, Object aValue) {
        this.features.putIfNotExists(aFeatureName, aValue);
    }

    public void overwrite(String aFeatureName, Object aValue) {
        this.features.overwrite(aFeatureName, aValue);
    }

    public void putOrOverwrite(String aFeatureName, Object aValue) {
        this.features.putOrOverwrite(aFeatureName, aValue);
    }

    public Object[] getObjectValues(Collection<String> aFeatures) {
        Object[] result = new Object[aFeatures.size()];
        int i = 0;
        for (String key : aFeatures) {
            result[i++] = this.features.get(key);
        }
        return result;
    }

    public float[] getFloatValues(Collection<String> aFloatFeatures) {
        float[] result = new float[aFloatFeatures.size()];
        int i = 0;
        for (String key : aFloatFeatures) {
            Object v = this.features.get(key);
            result[i++] = ((Float)v).floatValue();
        }
        return result;
    }

    public String[] getStringValues(Collection<String> aStringFeatures) {
        String[] result = new String[aStringFeatures.size()];
        int i = 0;
        for (String key : aStringFeatures) {
            result[i++] = (String)this.features.get(key);
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(new TreeMap<String, Object>(this.features));
        if (this.stopInfo != null) {
            b.append(", stop info: ");
            b.append(this.stopInfo);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureRecord record = (FeatureRecord)o;
        return Objects.equals(this.features, record.features) && Objects.equals(this.stopInfo, record.stopInfo);
    }

    public int hashCode() {
        return Objects.hash(this.features, this.stopInfo);
    }
}

