/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.mutators.MutatorException;
import io.bidmachine.utils.MathUtils;
import io.bidmachine.utils.Triple;
import java.util.HashSet;
import java.util.Set;

public class DemandStatsMutator
extends BaseMutator
implements Mutator {
    public static final String[] DEMANDSTATS_AD_TYPES = new String[]{"inter", "rewarded"};
    private static final Set<Long> PERFORMANCE_BIDDERS = Set.of(132L, 80L, 100L, 103L, 298L, 207L, 53L, 227L, 19L, 206L, 238L, 45L, 253L, 81L, 223L, 249L, 235L, 191L, 65L, 291L, 41L, 292L);

    @Override
    public Set<String> infoCalcFeatures() {
        return Set.of("competition_level_n", "competition_level_sum", "competition_level_cnt_avg", "competition_level_cnt_median", "competition_level_cnt_std", "performance_demand");
    }

    @Override
    public Set<String> infoInputFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (String adt : DEMANDSTATS_AD_TYPES) {
            features.add("demandstats_" + adt);
        }
        return features;
    }

    public DemandStatsMutator(String aID) {
        super(aID);
    }

    private void fixArray(long[][] aArray) {
        for (int i = 0; i < aArray.length; ++i) {
            if (aArray[i] != null) continue;
            aArray[i] = new long[0];
        }
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) throws MutatorException {
        return this.mutate(aFeatureRecord, PERFORMANCE_BIDDERS);
    }

    FeatureRecord mutate(FeatureRecord aFeatureRecord, Set<Long> aPerfBidders) throws MutatorException {
        long[][] demandstats_inter = (long[][])aFeatureRecord.get("demandstats_inter");
        long[][] demandstats_rewarded = (long[][])aFeatureRecord.get("demandstats_rewarded");
        if (demandstats_inter == null) {
            demandstats_inter = new long[0][0];
        } else {
            this.fixArray(demandstats_inter);
        }
        if (demandstats_rewarded == null) {
            demandstats_rewarded = new long[0][0];
        } else {
            this.fixArray(demandstats_rewarded);
        }
        long[][] demandstats = new long[demandstats_inter.length + demandstats_rewarded.length][];
        System.arraycopy(demandstats_inter, 0, demandstats, 0, demandstats_inter.length);
        System.arraycopy(demandstats_rewarded, 0, demandstats, demandstats_inter.length, demandstats_rewarded.length);
        int[] sizes = new int[demandstats.length];
        int[] performance = new int[demandstats.length];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = demandstats[i].length;
            int p = 0;
            for (int j = 0; j < sizes[i]; ++j) {
                if (!aPerfBidders.contains(demandstats[i][j])) continue;
                ++p;
            }
            performance[i] = p;
        }
        Triple<Double, Double, Double> t = MathUtils.sumMeanStd(sizes);
        double avgPerformance = MathUtils.mean(performance);
        aFeatureRecord.put("competition_level_n", sizes.length);
        aFeatureRecord.put("competition_level_sum", t.x);
        aFeatureRecord.put("competition_level_cnt_avg", t.y);
        aFeatureRecord.put("competition_level_cnt_median", MathUtils.medianWithArrayOverwrite(sizes));
        aFeatureRecord.put("competition_level_cnt_std", t.z);
        aFeatureRecord.put("performance_demand", avgPerformance);
        return aFeatureRecord;
    }
}

