/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.mutators.MutatorException;
import io.bidmachine.utils.DateUtils;
import io.bidmachine.utils.StringUtils;
import io.bidmachine.utils.TimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Set;

public class TimezoneMutator
extends BaseMutator
implements Mutator {
    public TimezoneMutator(String aID) {
        super(aID);
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) throws MutatorException {
        String timezone = (String)aFeatureRecord.get("timezone");
        String tzMostFrequent = (String)aFeatureRecord.get("tz_mostfrequent");
        String tzName = (String)aFeatureRecord.get("tz_name");
        String tzNameUnion = StringUtils.coalesce(timezone, tzName, tzMostFrequent);
        aFeatureRecord.put("tz_name_union", tzNameUnion);
        Instant ts = DateUtils.getInstant(aFeatureRecord.get("ts"));
        Instant clientTs = TimeUtils.convertToLocal(ts, tzNameUnion);
        if (clientTs != null) {
            aFeatureRecord.put("client_hours_diff", (double)Duration.between(ts, clientTs).getSeconds() / 3600.0);
            ZonedDateTime clientDateTime = clientTs.atZone(TimeUtils.UTCZoneOffset);
            int h = clientDateTime.getHour();
            aFeatureRecord.put("client_h", h);
            int m = clientDateTime.getMinute();
            aFeatureRecord.put("client_m", m);
            int s = clientDateTime.getSecond();
            aFeatureRecord.put("client_s", s);
            int client_s_day = h * 3600 + m * 60 + s;
            aFeatureRecord.put("client_s_day", client_s_day);
            aFeatureRecord.put("client_dow", clientDateTime.getDayOfWeek().getValue() - 1);
            double v = Math.PI * 2 * (double)client_s_day / 86400.0;
            aFeatureRecord.put("client_s_day_sin", Math.sin(v));
            aFeatureRecord.put("client_s_day_cos", Math.cos(v));
        } else {
            aFeatureRecord.put("client_hours_diff", null);
            aFeatureRecord.put("client_m", null);
            aFeatureRecord.put("client_s", null);
            aFeatureRecord.put("client_s_day", null);
            aFeatureRecord.put("client_dow", null);
            aFeatureRecord.put("client_s_day_sin", null);
            aFeatureRecord.put("client_s_day_cos", null);
        }
        return aFeatureRecord;
    }

    @Override
    public Set<String> infoCalcFeatures() {
        return Set.of("tz_name_union", "client_hours_diff", "client_m", "client_s", "client_s_day", "client_dow", "client_s_day_sin", "client_s_day_cos");
    }

    @Override
    public Set<String> infoInputFeatures() {
        return Set.of("ts", "timezone");
    }
}

