/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class CollectionUtils {
    static final String SETS_ARE_EQUAL = "Sets are equal";
    static final String FIRST_SET_DIFF_ITEMS = "1st set diff items: ";
    static final String SECOND_SET_DIFF_ITEMS = "2st set diff items: ";
    private static final String KEYS_AND_VALUES_SHOULD_BE_NOT_NULL = "Neither keys nor values can be null";
    private static final String KEYS_AND_VALUES_MUST_BE_THE_SAME_SIZE = "Keys and values must be of the same size";

    private CollectionUtils() {
    }

    public static <T> T[] removeNulls(T[] aArray, Class<T[]> aClazz) {
        int countNulls = 0;
        for (T item : aArray) {
            if (item != null) continue;
            ++countNulls;
        }
        T[] result = aClazz.cast(Array.newInstance(aClazz.getComponentType(), aArray.length - countNulls));
        int j = 0;
        for (T item : aArray) {
            if (item == null) continue;
            result[j++] = item;
        }
        return result;
    }

    public static <K, V> List<V> selectAsList(K[] aKeys, Map<K, V> aMap) {
        ArrayList<V> result = new ArrayList<V>(aKeys.length);
        for (K key : aKeys) {
            result.add(aMap.get(key));
        }
        return result;
    }

    private static <K, V> Map<K, V> filterMapByKeys(Map<K, V> aMap, Set<K> aKeys, boolean aInclude) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : aMap.entrySet()) {
            K k = entry.getKey();
            if (aKeys.contains(k) != aInclude) continue;
            result.put(k, entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<K, V> filterMapByKeys(Map<K, V> aMap, Collection<K> aKeys, boolean aInclude) {
        if (aKeys.getClass().isInstance(Set.class)) {
            return CollectionUtils.filterMapByKeys(aMap, (Set)Set.class.cast(aKeys), aInclude);
        }
        return CollectionUtils.filterMapByKeys(aMap, new HashSet<K>(aKeys), aInclude);
    }

    private static <T> void appendSetToBuilder(StringBuilder result, Set<T> aCopy, String aCaption) {
        if (!aCopy.isEmpty()) {
            result.append(aCaption);
            boolean isFirst = true;
            for (T item : aCopy) {
                if (!isFirst) {
                    result.append(", ");
                }
                result.append(item);
                isFirst = false;
            }
        }
    }

    public static <T> HashSet<T> intersect(Set<T> aSet1, Collection<T> ... aSets) {
        HashSet<T> result = new HashSet<T>(aSet1);
        for (Collection<T> s : aSets) {
            result.retainAll(s);
        }
        return result;
    }

    public static <T> HashSet<T> union(Collection<T> aSet1, Collection<T> ... aSets) {
        HashSet<T> result = new HashSet<T>(aSet1);
        for (Collection<T> s : aSets) {
            result.addAll(s);
        }
        return result;
    }

    public static <T> HashSet<T> minus(Collection<T> aSet1, Collection<T> ... aSets) {
        HashSet<T> result = new HashSet<T>(aSet1);
        for (Collection<T> s : aSets) {
            result.removeAll(s);
        }
        return result;
    }

    public static <T> String compareSets(Set<T> a, Set<T> b) {
        if (Objects.equals(a, b)) {
            return SETS_ARE_EQUAL;
        }
        StringBuilder result = new StringBuilder();
        HashSet<T> aCopy = new HashSet<T>();
        if (a != null) {
            aCopy.addAll(a);
        }
        HashSet<T> bCopy = new HashSet<T>();
        if (b != null) {
            bCopy.addAll(b);
        }
        if (b != null) {
            aCopy.removeAll(b);
        }
        CollectionUtils.appendSetToBuilder(result, aCopy, FIRST_SET_DIFF_ITEMS);
        if (result.length() > 0) {
            result.append(", ");
        }
        if (a != null) {
            bCopy.removeAll(a);
        }
        CollectionUtils.appendSetToBuilder(result, bCopy, SECOND_SET_DIFF_ITEMS);
        return result.toString();
    }

    public static <K, V> Map<K, V> zip(List<K> aKeys, List<V> aValues) {
        if (aKeys == null || aValues == null) {
            throw new IllegalArgumentException(KEYS_AND_VALUES_SHOULD_BE_NOT_NULL);
        }
        if (aKeys.size() != aValues.size()) {
            throw new IllegalArgumentException(KEYS_AND_VALUES_MUST_BE_THE_SAME_SIZE);
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < aKeys.size(); ++i) {
            result.put(aKeys.get(i), aValues.get(i));
        }
        return result;
    }

    public static <K, V> Map<K, V> zip(K[] aKeys, V[] aValues) {
        if (aKeys == null || aValues == null) {
            throw new IllegalArgumentException(KEYS_AND_VALUES_SHOULD_BE_NOT_NULL);
        }
        if (aKeys.length != aValues.length) {
            throw new IllegalArgumentException(KEYS_AND_VALUES_MUST_BE_THE_SAME_SIZE);
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < aKeys.length; ++i) {
            result.put(aKeys[i], aValues[i]);
        }
        return result;
    }

    public static String joinValues(String aDelimiter, Map<String, Object> aMap, Collection<String> aKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : aKeys) {
            list.add(aMap.get(key).toString());
        }
        return String.join((CharSequence)aDelimiter, list);
    }

    public static String joinNameValues(Map<String, Object> aMap, Collection<String> aKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : aKeys) {
            list.add(String.format("%s=%s", key, aMap.get(key).toString()));
        }
        return String.join((CharSequence)", ", list);
    }

    public static boolean compareDoubleMaps(Map<Integer, Double> aMap1, Map<Integer, Double> aMap2, double aPrecision) {
        if (aMap1 == null || aMap2 == null) {
            throw new IllegalArgumentException("Arguments can't be null");
        }
        if (!aMap1.keySet().equals(aMap2.keySet())) {
            return false;
        }
        for (Map.Entry<Integer, Double> entry : aMap1.entrySet()) {
            boolean oneIsNull;
            Integer key = entry.getKey();
            Double d1 = entry.getValue();
            Double d2 = aMap2.get(key);
            boolean bothAreNull = d1 == null && d2 == null;
            boolean bl = oneIsNull = d1 == null || d2 == null;
            if (bothAreNull || !oneIsNull && !(Math.abs(d1 - d2) > aPrecision)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> String toStrSorted(Collection<T> aCol) {
        return CollectionUtils.toStrSorted(aCol, ", ");
    }

    public static <T extends Comparable<? super T>> String toStrSorted(Collection<T> aCol, String aDelimiter) {
        ArrayList<T> sortedList = new ArrayList<T>(aCol);
        Collections.sort(sortedList);
        return CollectionUtils.toStr(sortedList, aDelimiter);
    }

    public static <T extends Comparable<? super T>> String toStrSorted(T[] a, String aDelimiter) {
        Object[] sortedArray = (Comparable[])Arrays.copyOf(a, a.length);
        Arrays.sort(sortedArray);
        return CollectionUtils.toStr(Arrays.asList(sortedArray), aDelimiter);
    }

    public static <T> String toStr(Collection<T> aCol) {
        return CollectionUtils.toStr(aCol, ", ");
    }

    public static <T> String toStr(Collection<T> aCol, String aDelimiter) {
        if (aCol == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        boolean isFirst = true;
        for (T o : aCol) {
            if (!isFirst) {
                b.append(aDelimiter);
            }
            isFirst = false;
            if (o == null) {
                b.append("null");
                continue;
            }
            b.append(o);
        }
        b.append("]");
        return b.toString();
    }

    public static <T> String toStr(T[] aCol) {
        if (aCol == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        boolean isFirst = true;
        for (T item : aCol) {
            if (!isFirst) {
                b.append(", ");
            }
            isFirst = false;
            if (item == null) {
                b.append("null");
                continue;
            }
            b.append(item);
        }
        b.append("]");
        return b.toString();
    }

    public static String toStr(double[] aCol) {
        if (aCol == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        boolean isFirst = true;
        for (int i = 0; i < aCol.length; ++i) {
            if (!isFirst) {
                b.append(", ");
            }
            isFirst = false;
            b.append(String.format("%.6f", aCol[i]));
        }
        b.append("]");
        return b.toString();
    }

    public static String toStr(float[] aCol) {
        if (aCol == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        boolean isFirst = true;
        for (int i = 0; i < aCol.length; ++i) {
            if (!isFirst) {
                b.append(", ");
            }
            isFirst = false;
            b.append(String.format("%.6f", Float.valueOf(aCol[i])));
        }
        b.append("]");
        return b.toString();
    }

    public static String toStr(int[] aCol) {
        if (aCol == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        boolean isFirst = true;
        for (int i = 0; i < aCol.length; ++i) {
            if (!isFirst) {
                b.append(", ");
            }
            isFirst = false;
            b.append(String.valueOf(aCol[i]));
        }
        b.append("]");
        return b.toString();
    }

    public static <K, V> String toStr(Map<K, V> aMap) {
        return CollectionUtils.toStr(aMap, ", ");
    }

    public static <K, V> String toStrEnter(Map<K, V> aMap) {
        return CollectionUtils.toStr(aMap, System.lineSeparator());
    }

    public static <K, V> String toStr(Map<K, V> aMap, String aDelimiter) {
        if (aMap == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<K, V> entry : aMap.entrySet()) {
            list.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return "{" + String.join((CharSequence)aDelimiter, list) + "}";
    }

    public static <K, V> String toStrWithTypesSorted(Map<K, V> aMap, String aDelimiter) {
        return CollectionUtils.toStrWithTypes(new TreeMap<K, V>(aMap), aDelimiter);
    }

    public static <K, V> String toStrWithTypes(Map<K, V> aMap, String aDelimiter) {
        if (aMap == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<K, V> entry : aMap.entrySet()) {
            V v = entry.getValue();
            String theType = v == null ? "null" : v.getClass().getSimpleName();
            list.add(String.format("%s (%s) = %s", entry.getKey(), theType, v));
        }
        return "{" + String.join((CharSequence)aDelimiter, list) + "}";
    }
}

