/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import io.bidmachine.utils.Triple;
import java.util.Arrays;

public class MathUtils {
    private static final double[] POWERS_OF_10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};

    public static double round(double aValue, int aPlaces) {
        if (aPlaces < 0) {
            return aValue;
        }
        if (aPlaces == 0) {
            return Math.round(aValue);
        }
        double factor = aPlaces <= 9 ? POWERS_OF_10[aPlaces] : Math.pow(10.0, aPlaces);
        return (double)Math.round(aValue * factor) / factor;
    }

    public static void applySigmoid(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = 1.0 / (1.0 + Math.exp(-x[i]));
        }
    }

    public static void applyExp(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.exp(x[i]);
        }
    }

    public static Triple<Double, Double, Double> sumMeanStd(int[] a) {
        if (a.length == 0) {
            return new Triple<Double, Double, Double>(Double.NaN, Double.NaN, Double.NaN);
        }
        int sum = 0;
        for (int size : a) {
            sum += size;
        }
        double avg = (double)sum / (double)a.length;
        double sumSquaredDiffs = 0.0;
        int[] nArray = a;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long v = nArray[i];
            double diff = (double)v - avg;
            sumSquaredDiffs += diff * diff;
        }
        double std = Math.sqrt(sumSquaredDiffs / (double)a.length);
        return new Triple<Double, Double, Double>(Double.valueOf(sum), avg, std);
    }

    public static double mean(long[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (long v : a) {
            sum += (double)v;
        }
        return sum / (double)a.length;
    }

    public static double mean(int[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int[] nArray = a;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long v = nArray[i];
            sum += (double)v;
        }
        return sum / (double)a.length;
    }

    public static double std(long[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double mean = MathUtils.mean(a);
        double sumSquaredDiffs = 0.0;
        for (long v : a) {
            double diff = (double)v - mean;
            sumSquaredDiffs += diff * diff;
        }
        return Math.sqrt(sumSquaredDiffs / (double)a.length);
    }

    public static double medianWithArrayOverwrite(int[] a) {
        int n = a.length;
        if (n == 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return a[0];
        }
        Arrays.sort(a);
        int mid = n / 2;
        return n % 2 == 0 ? (double)(a[mid - 1] + a[mid]) / 2.0 : (double)a[mid];
    }
}

