/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class TimeUtils {
    public static final ZoneOffset UTCZoneOffset = ZoneOffset.UTC;

    public static double secondsSince(long aStartMilli, Instant aNow) {
        long nowMillis = aNow.toEpochMilli();
        return (double)(nowMillis - aStartMilli) / 1000.0;
    }

    public static ZoneId getValidTimezone(String tzStr) {
        if (tzStr == null || tzStr.trim().isEmpty()) {
            return null;
        }
        try {
            return ZoneId.of(tzStr);
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    public static Instant convertToLocal(Instant aInstant, String aTimezone) {
        if (aTimezone == null || aTimezone.trim().isEmpty() || "__NULL__".equals(aTimezone)) {
            return null;
        }
        ZoneId zone = TimeUtils.getValidTimezone(aTimezone);
        if (zone == null || aInstant == null) {
            return null;
        }
        ZonedDateTime targetZone = ZonedDateTime.ofInstant(aInstant, zone);
        return targetZone.toLocalDateTime().toInstant(UTCZoneOffset);
    }
}

