/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.config.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.bidmachine.config.data.FieldConfig;
import io.bidmachine.config.data.SchemaConfig;
import io.bidmachine.config.exceptions.ConfigException;
import io.bidmachine.config.providers.ConfigProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class SchemaConfigReader {
    private SchemaConfigReader() {
    }

    public static SchemaConfig read(Reader aReader) throws ConfigException {
        Gson gson = new Gson();
        BufferedReader br = new BufferedReader(aReader);
        SchemaConfig conf = (SchemaConfig)gson.fromJson((Reader)br, new TypeToken<SchemaConfig>(){}.getType());
        for (FieldConfig fc : conf.getFieldConfigs()) {
            if (fc.getType() != null) continue;
            throw new ConfigException(String.format("Field %s has wrong data type", fc.getName()));
        }
        return conf;
    }

    public static SchemaConfig read(InputStream aStream) throws ConfigException {
        return SchemaConfigReader.read(new InputStreamReader(aStream));
    }

    public static SchemaConfig read(ConfigProvider aConfigProvider, String aResourcePath) throws ConfigException {
        try {
            return SchemaConfigReader.read(aConfigProvider.getInputStream(aResourcePath));
        }
        catch (ConfigException ex) {
            throw new ConfigException(ex.getMessage() + String.format(". Resource: %s, provider: %s", aResourcePath, aConfigProvider));
        }
    }

    public static SchemaConfig read(String aJson) throws ConfigException {
        return SchemaConfigReader.read(new StringReader(aJson));
    }
}

