/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.csv;

import io.bidmachine.config.data.FieldConfig;
import io.bidmachine.config.data.SchemaConfig;
import io.bidmachine.csv.ParseDoubleHex;
import io.bidmachine.csv.ParseFloatHex;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class SchemaCsvBridge {
    private SchemaCsvBridge() {
    }

    public static CellProcessor[] createProcessors(SchemaConfig aSchemaConfig) {
        CellProcessor[] result = new CellProcessor[aSchemaConfig.getFieldConfigs().size()];
        int i = 0;
        for (FieldConfig fc : aSchemaConfig.getFieldConfigs()) {
            boolean canBeNull = fc.getMandatory() == false;
            switch (fc.getType()) {
                case STRING: {
                    result[i] = null;
                    break;
                }
                case INT: {
                    result[i] = canBeNull ? new Optional((CellProcessor)new ParseInt()) : new ParseInt();
                    break;
                }
                case LONG: {
                    result[i] = canBeNull ? new Optional((CellProcessor)new ParseLong()) : new ParseLong();
                    break;
                }
                case FLOAT: {
                    result[i] = canBeNull ? new Optional((CellProcessor)new ParseFloatHex()) : new ParseFloatHex();
                    break;
                }
                case DOUBLE: {
                    result[i] = canBeNull ? new Optional((CellProcessor)new ParseDoubleHex()) : new ParseDoubleHex();
                    break;
                }
                case BOOL: {
                    result[i] = canBeNull ? new Optional((CellProcessor)new ParseBool()) : new ParseBool();
                    break;
                }
                case DATETIME: {
                    ParseDate pd = new ParseDate("yyyy-MM-dd HH:mm:ss.SSS", true);
                    result[i] = canBeNull ? new Optional((CellProcessor)pd) : pd;
                }
            }
            ++i;
        }
        return result;
    }
}

