/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.util.HashMap;
import java.util.Map;

public class CheckedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final String KEY_CANT_BE_NULL = "The key cannot be null";

    public CheckedHashMap() {
    }

    public CheckedHashMap(Map<? extends K, ? extends V> aMap) {
        super(aMap);
    }

    @Override
    public V put(K aKey, V aValue) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        if (this.containsKey(aKey)) {
            throw new IllegalArgumentException(String.format("The key %s already exists in the map.", aKey));
        }
        return super.put(aKey, aValue);
    }

    public void putIfNotExists(K aKey, V aValue) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        if (!this.containsKey(aKey)) {
            super.put(aKey, aValue);
        }
    }

    public V overwrite(K aKey, V aValue) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        if (!this.containsKey(aKey)) {
            throw new IllegalArgumentException(String.format("The key %s doesn't exist in the map.", aKey));
        }
        return super.put(aKey, aValue);
    }

    public V putOrOverwrite(K aKey, V aValue) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        return super.put(aKey, aValue);
    }

    @Override
    public V get(Object aKey) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        if (!this.containsKey(aKey)) {
            throw new IllegalArgumentException(String.format("The key %s is not found.", aKey));
        }
        return super.get(aKey);
    }

    @Override
    public V remove(Object aKey) {
        if (aKey == null) {
            throw new IllegalArgumentException(KEY_CANT_BE_NULL);
        }
        if (!this.containsKey(aKey)) {
            throw new IllegalArgumentException("Cannot remove key %s because it doesn't exist");
        }
        return super.remove(aKey);
    }
}

