/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.infobip.mobile.messaging.api.support.NoHttpRequestAnnotation;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.api.support.http.ApiKey;
import org.infobip.mobile.messaging.api.support.http.Body;
import org.infobip.mobile.messaging.api.support.http.Credentials;
import org.infobip.mobile.messaging.api.support.http.Header;
import org.infobip.mobile.messaging.api.support.http.Headers;
import org.infobip.mobile.messaging.api.support.http.HttpRequest;
import org.infobip.mobile.messaging.api.support.http.Path;
import org.infobip.mobile.messaging.api.support.http.Paths;
import org.infobip.mobile.messaging.api.support.http.Queries;
import org.infobip.mobile.messaging.api.support.http.Query;
import org.infobip.mobile.messaging.api.support.http.Version;
import org.infobip.mobile.messaging.api.support.http.client.DefaultApiClient;
import org.infobip.mobile.messaging.api.support.http.client.HttpMethod;
import org.infobip.mobile.messaging.api.support.http.client.Logger;
import org.infobip.mobile.messaging.api.support.http.client.RequestInterceptor;
import org.infobip.mobile.messaging.api.support.http.client.ResponsePreProcessor;
import org.infobip.mobile.messaging.api.support.util.ReflectionUtils;
import org.infobip.mobile.messaging.api.support.util.StringUtils;

public class Generator {
    private DefaultApiClient apiClient;
    private String baseUrl = "https://mobile.infobip.com/";
    private ConcurrentHashMap<Class<?>, CachingInvocationHandler> proxyCacheMap = new ConcurrentHashMap();
    private Properties properties = System.getProperties();
    private int connectTimeout = 5000;
    private int readTimeout = 60000;
    private String[] userAgentAdditions = new String[0];
    private RequestInterceptor[] requestInterceptors = new RequestInterceptor[0];
    private ResponsePreProcessor[] responsePreProcessors = new ResponsePreProcessor[0];
    private Logger logger = new Logger();
    private boolean allowUntrustedSSLOnError = false;

    private DefaultApiClient getApiClient() {
        if (null != this.apiClient) {
            return this.apiClient;
        }
        String libraryVersion = this.properties.getProperty("library.version");
        this.apiClient = new DefaultApiClient(this.connectTimeout, this.readTimeout, libraryVersion, this.requestInterceptors, this.responsePreProcessors, this.logger, this.allowUntrustedSSLOnError, this.userAgentAdditions);
        return this.apiClient;
    }

    public <T> T create(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        CachingInvocationHandler<T> cachingInvocationHandler = this.proxyCacheMap.get(type);
        if (null == cachingInvocationHandler) {
            cachingInvocationHandler = new CachingInvocationHandler<T>(type);
            this.proxyCacheMap.put(type, cachingInvocationHandler);
        }
        return cachingInvocationHandler.getProxy();
    }

    private Version getVersionAnnotation(Method method) {
        Version version = method.getAnnotation(Version.class);
        if (null != version) {
            return version;
        }
        version = method.getDeclaringClass().getAnnotation(Version.class);
        if (null != version) {
            return version;
        }
        return this.getPackageAnnotation(method.getDeclaringClass().getPackage().getName(), Version.class);
    }

    private ApiKey getApiKeyAnnotation(Method method) {
        ApiKey apiKey = method.getAnnotation(ApiKey.class);
        if (null != apiKey) {
            return apiKey;
        }
        apiKey = method.getDeclaringClass().getAnnotation(ApiKey.class);
        if (null != apiKey) {
            return apiKey;
        }
        return this.getPackageAnnotation(method.getDeclaringClass().getPackage().getName(), ApiKey.class);
    }

    private Credentials getCredentialsAnnotation(Method method) {
        Credentials credentials = method.getAnnotation(Credentials.class);
        if (null != credentials) {
            return credentials;
        }
        credentials = method.getDeclaringClass().getAnnotation(Credentials.class);
        if (null != credentials) {
            return credentials;
        }
        return this.getPackageAnnotation(method.getDeclaringClass().getPackage().getName(), Credentials.class);
    }

    private <T extends Annotation> T getPackageAnnotation(String pkg, Class<T> annotationClass) {
        T t;
        Package p = Package.getPackage(pkg);
        if (null == p) {
            try {
                ReflectionUtils.loadPackageInfo(pkg);
                p = Package.getPackage(pkg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != p && null != (t = p.getAnnotation(annotationClass))) {
            return t;
        }
        if (pkg.length() == 0) {
            return null;
        }
        int endIndex = pkg.lastIndexOf(46);
        pkg = endIndex < 0 ? "" : pkg.substring(0, endIndex);
        return this.getPackageAnnotation(pkg, annotationClass);
    }

    private <T> T getAnnotation(Annotation[] annotations, Class<T> type) {
        for (Annotation annotation : annotations) {
            if (!type.isAssignableFrom(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }

    private Collection<Object> toCollection(Object arg) {
        if (null == arg) {
            return null;
        }
        if (arg instanceof Collection) {
            return (Collection)arg;
        }
        if (arg.getClass().isArray()) {
            int length = Array.getLength(arg);
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                objects.add(Array.get(arg, i));
            }
            return objects;
        }
        return Collections.singleton(arg);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public ConcurrentHashMap<Class<?>, CachingInvocationHandler> getProxyCacheMap() {
        return this.proxyCacheMap;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String[] getUserAgentAdditions() {
        return this.userAgentAdditions;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public ResponsePreProcessor[] getResponsePreProcessors() {
        return this.responsePreProcessors;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isAllowUntrustedSSLOnError() {
        return this.allowUntrustedSSLOnError;
    }

    public void setApiClient(DefaultApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setProxyCacheMap(ConcurrentHashMap<Class<?>, CachingInvocationHandler> proxyCacheMap) {
        this.proxyCacheMap = proxyCacheMap;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setUserAgentAdditions(String[] userAgentAdditions) {
        this.userAgentAdditions = userAgentAdditions;
    }

    public void setRequestInterceptors(RequestInterceptor[] requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public void setResponsePreProcessors(ResponsePreProcessor[] responsePreProcessors) {
        this.responsePreProcessors = responsePreProcessors;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setAllowUntrustedSSLOnError(boolean allowUntrustedSSLOnError) {
        this.allowUntrustedSSLOnError = allowUntrustedSSLOnError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Generator)) {
            return false;
        }
        Generator other = (Generator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DefaultApiClient this$apiClient = this.getApiClient();
        DefaultApiClient other$apiClient = other.getApiClient();
        if (this$apiClient == null ? other$apiClient != null : !this$apiClient.equals(other$apiClient)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        ConcurrentHashMap<Class<?>, CachingInvocationHandler> this$proxyCacheMap = this.getProxyCacheMap();
        ConcurrentHashMap<Class<?>, CachingInvocationHandler> other$proxyCacheMap = other.getProxyCacheMap();
        if (this$proxyCacheMap == null ? other$proxyCacheMap != null : !((Object)this$proxyCacheMap).equals(other$proxyCacheMap)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUserAgentAdditions(), other.getUserAgentAdditions())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRequestInterceptors(), other.getRequestInterceptors())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResponsePreProcessors(), other.getResponsePreProcessors())) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        return this.isAllowUntrustedSSLOnError() == other.isAllowUntrustedSSLOnError();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Generator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultApiClient $apiClient = this.getApiClient();
        result = result * 59 + ($apiClient == null ? 43 : $apiClient.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        ConcurrentHashMap<Class<?>, CachingInvocationHandler> $proxyCacheMap = this.getProxyCacheMap();
        result = result * 59 + ($proxyCacheMap == null ? 43 : ((Object)$proxyCacheMap).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + Arrays.deepHashCode(this.getUserAgentAdditions());
        result = result * 59 + Arrays.deepHashCode(this.getRequestInterceptors());
        result = result * 59 + Arrays.deepHashCode(this.getResponsePreProcessors());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        result = result * 59 + (this.isAllowUntrustedSSLOnError() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Generator(apiClient=" + this.getApiClient() + ", baseUrl=" + this.getBaseUrl() + ", proxyCacheMap=" + this.getProxyCacheMap() + ", properties=" + this.getProperties() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", userAgentAdditions=" + Arrays.deepToString(this.getUserAgentAdditions()) + ", requestInterceptors=" + Arrays.deepToString(this.getRequestInterceptors()) + ", responsePreProcessors=" + Arrays.deepToString(this.getResponsePreProcessors()) + ", logger=" + this.getLogger() + ", allowUntrustedSSLOnError=" + this.isAllowUntrustedSSLOnError() + ")";
    }

    static /* synthetic */ RequestInterceptor[] access$002(Generator x0, RequestInterceptor[] x1) {
        x0.requestInterceptors = x1;
        return x1;
    }

    static /* synthetic */ ResponsePreProcessor[] access$102(Generator x0, ResponsePreProcessor[] x1) {
        x0.responsePreProcessors = x1;
        return x1;
    }

    private class ProxyCache {
        private final HttpRequest[] httpRequests;
        private final String uri;
        private final HashMap<String, Collection<Object>> defaultQueryParams;
        private final HashMap<String, Collection<Object>> defaultHeaderMap;
        private final Parameter[] parameters;
        private final String apiKey;
        private final Tuple<String, String> credentials;

        public ProxyCache(Method method) {
            this.httpRequests = this.createHttpRequest(method);
            this.uri = this.createUri(method);
            this.defaultQueryParams = this.createDefaultQueryParams(method);
            this.defaultHeaderMap = this.createDefaultHeaderMap(method);
            this.parameters = this.createParameters(method);
            this.apiKey = this.findApiKey(method);
            this.credentials = this.findCredentials(method);
        }

        private String findApiKey(Method method) {
            ApiKey apiKeyAnotation = Generator.this.getApiKeyAnnotation(method);
            if (null == apiKeyAnotation) {
                return null;
            }
            return this.injectProperty(apiKeyAnotation.value());
        }

        private Tuple<String, String> findCredentials(Method method) {
            Credentials credentialsAnnotation = Generator.this.getCredentialsAnnotation(method);
            if (null == credentialsAnnotation) {
                return null;
            }
            return new Tuple<String, String>(this.injectProperty(credentialsAnnotation.user()), this.injectProperty(credentialsAnnotation.password()));
        }

        private Parameter[] createParameters(Method method) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Parameter[] parameters = new Parameter[parameterAnnotations.length];
            int i = 0;
            for (Annotation[] annotations : parameterAnnotations) {
                Parameter parameter = new Parameter((Body)Generator.this.getAnnotation(annotations, Body.class), (Path)Generator.this.getAnnotation(annotations, Path.class), (Query)Generator.this.getAnnotation(annotations, Query.class), (Header)Generator.this.getAnnotation(annotations, Header.class), (Version)Generator.this.getAnnotation(annotations, Version.class));
                parameters[i++] = parameter;
            }
            return parameters;
        }

        private HttpRequest[] createHttpRequest(Method method) {
            HttpRequest httpRequestOnClass = method.getDeclaringClass().getAnnotation(HttpRequest.class);
            HttpRequest httpRequest = method.getAnnotation(HttpRequest.class);
            if (null != httpRequest && null != httpRequestOnClass) {
                return new HttpRequest[]{httpRequestOnClass, httpRequest};
            }
            if (null != httpRequest) {
                return new HttpRequest[]{httpRequest};
            }
            if (null != httpRequestOnClass) {
                return new HttpRequest[]{httpRequestOnClass};
            }
            throw new NoHttpRequestAnnotation("Method '" + method.getName() + "' must be annotated with @HttpRequest!");
        }

        private String createUri(Method method) {
            Paths paths;
            Path path;
            String uri = this.getHttpRequestValue();
            Version version = Generator.this.getVersionAnnotation(method);
            if (null != version) {
                uri = uri.replace("{version}", this.injectProperty(version.value()));
            }
            if (null != (path = method.getAnnotation(Path.class))) {
                uri = uri.replace("{" + path.name() + "}", this.injectProperty(path.value()));
            }
            if (null != (paths = method.getAnnotation(Paths.class))) {
                for (Path p : paths.value()) {
                    uri = uri.replace("{" + p.name() + "}", this.injectProperty(p.value()));
                }
            }
            return uri;
        }

        private String getHttpRequestValue() {
            String uri = "";
            for (HttpRequest httpRequest : this.httpRequests) {
                uri = StringUtils.join("/", uri, httpRequest.value());
            }
            return uri;
        }

        private String injectProperty(String s) {
            if (StringUtils.isBlank(s)) {
                return s;
            }
            if (s.startsWith("${") && s.endsWith("}")) {
                s = s.substring(2, s.length() - 1);
                String[] split = s.split(":");
                return Generator.this.properties.getProperty(split[0], split.length > 1 ? split[1] : null);
            }
            return s;
        }

        private Collection<Object> injectProperty(String[] strings) {
            if (null == strings) {
                return null;
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            for (String s : strings) {
                objects.add(this.injectProperty(s));
            }
            return objects;
        }

        private HashMap<String, Collection<Object>> createDefaultQueryParams(Method method) {
            Queries queries;
            HashMap<String, Collection<Object>> queryParams = new HashMap<String, Collection<Object>>();
            Query query = method.getAnnotation(Query.class);
            if (null != query) {
                queryParams.put(query.name(), this.injectProperty(query.value()));
            }
            if (null != (queries = method.getAnnotation(Queries.class))) {
                for (Query q : queries.value()) {
                    queryParams.put(q.name(), this.injectProperty(q.value()));
                }
            }
            return queryParams;
        }

        private HashMap<String, Collection<Object>> createDefaultHeaderMap(Method method) {
            Headers headers;
            HashMap<String, Collection<Object>> headerMap = new HashMap<String, Collection<Object>>();
            Header header = method.getAnnotation(Header.class);
            if (null != header) {
                headerMap.put(header.name(), this.injectProperty(header.value()));
            }
            if (null != (headers = method.getAnnotation(Headers.class))) {
                for (Header q : headers.value()) {
                    headerMap.put(q.name(), this.injectProperty(q.value()));
                }
            }
            return headerMap;
        }

        public HttpRequest[] getHttpRequests() {
            return this.httpRequests;
        }

        public String getUri() {
            return this.uri;
        }

        public HashMap<String, Collection<Object>> getDefaultQueryParams() {
            return this.defaultQueryParams;
        }

        public HashMap<String, Collection<Object>> getDefaultHeaderMap() {
            return this.defaultHeaderMap;
        }

        public Parameter[] getParameters() {
            return this.parameters;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public Tuple<String, String> getCredentials() {
            return this.credentials;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyCache)) {
                return false;
            }
            ProxyCache other = (ProxyCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getHttpRequests(), other.getHttpRequests())) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            HashMap<String, Collection<Object>> this$defaultQueryParams = this.getDefaultQueryParams();
            HashMap<String, Collection<Object>> other$defaultQueryParams = other.getDefaultQueryParams();
            if (this$defaultQueryParams == null ? other$defaultQueryParams != null : !((Object)this$defaultQueryParams).equals(other$defaultQueryParams)) {
                return false;
            }
            HashMap<String, Collection<Object>> this$defaultHeaderMap = this.getDefaultHeaderMap();
            HashMap<String, Collection<Object>> other$defaultHeaderMap = other.getDefaultHeaderMap();
            if (this$defaultHeaderMap == null ? other$defaultHeaderMap != null : !((Object)this$defaultHeaderMap).equals(other$defaultHeaderMap)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getParameters(), other.getParameters())) {
                return false;
            }
            String this$apiKey = this.getApiKey();
            String other$apiKey = other.getApiKey();
            if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
                return false;
            }
            Tuple<String, String> this$credentials = this.getCredentials();
            Tuple<String, String> other$credentials = other.getCredentials();
            return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProxyCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getHttpRequests());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            HashMap<String, Collection<Object>> $defaultQueryParams = this.getDefaultQueryParams();
            result = result * 59 + ($defaultQueryParams == null ? 43 : ((Object)$defaultQueryParams).hashCode());
            HashMap<String, Collection<Object>> $defaultHeaderMap = this.getDefaultHeaderMap();
            result = result * 59 + ($defaultHeaderMap == null ? 43 : ((Object)$defaultHeaderMap).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParameters());
            String $apiKey = this.getApiKey();
            result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
            Tuple<String, String> $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.ProxyCache(httpRequests=" + Arrays.deepToString(this.getHttpRequests()) + ", uri=" + this.getUri() + ", defaultQueryParams=" + this.getDefaultQueryParams() + ", defaultHeaderMap=" + this.getDefaultHeaderMap() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ", apiKey=" + this.getApiKey() + ", credentials=" + this.getCredentials() + ")";
        }
    }

    private class Parameter {
        private final Body body;
        private final Path path;
        private final Query query;
        private final Header header;
        private final Version version;

        public Parameter(Body body, Path path, Query query, Header header, Version version) {
            this.body = body;
            this.path = path;
            this.query = query;
            this.header = header;
            this.version = version;
        }

        public Body getBody() {
            return this.body;
        }

        public Path getPath() {
            return this.path;
        }

        public Query getQuery() {
            return this.query;
        }

        public Header getHeader() {
            return this.header;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Body this$body = this.getBody();
            Body other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Query this$query = this.getQuery();
            Query other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Header this$header = this.getHeader();
            Header other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Body $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Query $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Header $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.Parameter(body=" + this.getBody() + ", path=" + this.getPath() + ", query=" + this.getQuery() + ", header=" + this.getHeader() + ", version=" + this.getVersion() + ")";
        }
    }

    private class CachingInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> type;
        private ConcurrentHashMap<Method, ProxyCache> proxyCacheMap = new ConcurrentHashMap();

        public T getProxy() {
            return (T)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ProxyCache proxyCache = this.getProxyCache(method);
            String uri = StringUtils.join("/", Generator.this.baseUrl, proxyCache.getUri());
            HashMap<String, Collection<Object>> queryParams = new HashMap<String, Collection<Object>>(proxyCache.getDefaultQueryParams());
            HashMap<String, Collection<Object>> headerMap = new HashMap<String, Collection<Object>>(proxyCache.getDefaultHeaderMap());
            String apiKey = proxyCache.getApiKey();
            Tuple<String, String> credentials = proxyCache.getCredentials();
            Parameter[] parameters = proxyCache.getParameters();
            Object body = null;
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                Header h;
                Query q;
                Path p;
                Version version;
                Parameter parameter = parameters[i];
                Object arg = args[i];
                if (null != parameter.getBody()) {
                    body = arg;
                }
                if (null != (version = parameter.getVersion())) {
                    uri = uri.replace("{version}", arg.toString());
                }
                if (null != (p = parameter.getPath())) {
                    uri = uri.replace("{" + p.name() + "}", arg.toString());
                }
                if (null != (q = parameter.getQuery())) {
                    String name = q.name();
                    queryParams.put(name, Generator.this.toCollection(arg));
                }
                if (null == (h = parameter.getHeader())) continue;
                String name = h.name();
                headerMap.put(name, Generator.this.toCollection(arg));
            }
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            return Generator.this.getApiClient().execute(this.getHttpRequestMethod(proxyCache.httpRequests), uri, apiKey, credentials, queryParams, headerMap, body, method.getReturnType());
        }

        private HttpMethod getHttpRequestMethod(HttpRequest[] httpRequests) {
            HttpMethod method = HttpMethod.GET;
            for (HttpRequest httpRequest : httpRequests) {
                method = httpRequest.method();
            }
            return method;
        }

        private ProxyCache getProxyCache(Method method) {
            ProxyCache proxyCache = this.proxyCacheMap.get(method);
            if (null != proxyCache) {
                return proxyCache;
            }
            proxyCache = new ProxyCache(method);
            this.proxyCacheMap.put(method, proxyCache);
            return proxyCache;
        }

        public CachingInvocationHandler(Class<T> type) {
            this.type = type;
        }

        public Class<T> getType() {
            return this.type;
        }

        public ConcurrentHashMap<Method, ProxyCache> getProxyCacheMap() {
            return this.proxyCacheMap;
        }

        public void setProxyCacheMap(ConcurrentHashMap<Method, ProxyCache> proxyCacheMap) {
            this.proxyCacheMap = proxyCacheMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachingInvocationHandler)) {
                return false;
            }
            CachingInvocationHandler other = (CachingInvocationHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ConcurrentHashMap<Method, ProxyCache> this$proxyCacheMap = this.getProxyCacheMap();
            ConcurrentHashMap<Method, ProxyCache> other$proxyCacheMap = other.getProxyCacheMap();
            return !(this$proxyCacheMap == null ? other$proxyCacheMap != null : !((Object)this$proxyCacheMap).equals(other$proxyCacheMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CachingInvocationHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ConcurrentHashMap<Method, ProxyCache> $proxyCacheMap = this.getProxyCacheMap();
            result = result * 59 + ($proxyCacheMap == null ? 43 : ((Object)$proxyCacheMap).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.CachingInvocationHandler(type=" + this.getType() + ", proxyCacheMap=" + this.getProxyCacheMap() + ")";
        }
    }

    public static class Builder {
        private final Generator generator = new Generator();

        public Builder withBaseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.generator.setBaseUrl(baseUrl);
            return this;
        }

        public Builder withProperties(@NonNull Properties properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.generator.setProperties(properties);
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.generator.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.generator.setReadTimeout(readTimeout);
            return this;
        }

        public Builder withUserAgentAdditions(String ... userAgentAdditions) {
            if (userAgentAdditions == null) {
                throw new NullPointerException("userAgentAdditions is marked non-null but is null");
            }
            this.generator.setUserAgentAdditions(userAgentAdditions);
            return this;
        }

        public Builder withRequestInterceptors(RequestInterceptor ... requestInterceptors) {
            if (requestInterceptors == null) {
                throw new NullPointerException("requestInterceptors is marked non-null but is null");
            }
            Generator.access$002(this.generator, requestInterceptors);
            return this;
        }

        public Builder withResponseHeaderInterceptors(ResponsePreProcessor ... responsePreProcessors) {
            if (responsePreProcessors == null) {
                throw new NullPointerException("responsePreProcessors is marked non-null but is null");
            }
            Generator.access$102(this.generator, responsePreProcessors);
            return this;
        }

        public Builder withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.generator.logger = logger;
            return this;
        }

        public Builder withAllowUntrustedSSLOnError(boolean allowUntrustedSSLOnError) {
            this.generator.allowUntrustedSSLOnError = allowUntrustedSSLOnError;
            return this;
        }

        public Generator build() {
            if (StringUtils.isBlank(this.generator.getBaseUrl())) {
                throw new IllegalArgumentException("baseUrl is mandatory");
            }
            return this.generator;
        }
    }
}

