/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class MapUtils {
    public static Map<String, Collection<Object>> map(Object ... kvargs) {
        HashMap<String, Collection<Object>> hashMap = new HashMap<String, Collection<Object>>();
        for (int i = 0; i < kvargs.length; i += 2) {
            hashMap.put(kvargs[i].toString(), Collections.singleton(kvargs[i + 1]));
        }
        return hashMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concat(Map<K, V> ... mps) {
        return MapUtils.concat(null, mps);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concatOrEmpty(Map<K, V> ... mps) {
        return MapUtils.concat(Collections.emptyMap(), mps);
    }

    @SafeVarargs
    private static <K, V> Map<K, V> concat(Map<K, V> valueIfEmpty, Map<K, V> ... mps) {
        LinkedList<Map<K, V>> maps = new LinkedList<Map<K, V>>(Arrays.asList(mps));
        Iterator iterator = maps.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (map != null) continue;
            iterator.remove();
        }
        if (maps.isEmpty()) {
            return valueIfEmpty;
        }
        HashMap result = new HashMap();
        for (int i = 0; i < maps.size(); ++i) {
            result.putAll((Map)maps.get(i));
        }
        return result;
    }
}

