/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.api.support.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamUtils {
    private StreamUtils() {
    }

    public static String readToString(InputStream inputStream, String charsetName, long length) throws IOException {
        String stringFromStream;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = inputStream.read();
        long count = 1L;
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            if (count == length) break;
            result = inputStream.read();
            ++count;
        }
        if ((stringFromStream = buf.toString(charsetName)).length() < 1) {
            return "";
        }
        return stringFromStream;
    }

    public static long write(String s, OutputStream outputStream, String charsetName) throws IOException {
        return StreamUtils.write(s.getBytes(charsetName), outputStream);
    }

    private static long write(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        return bytes.length;
    }

    public static void closeSafely(OutputStream outputStream) {
        if (null == outputStream) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

